
// Copyright  2002-2010 Luigi Pino. All Rights Reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_WINDOW_H_
#define _NEUROSIS_ENGINE_WINDOW_H_

/***************************************************************************/

#include <vfw.h>
#include <gdiplus.h>
using namespace Gdiplus;

/***************************************************************************/

class CWindow {
	public:
		CWindow(float zNear, float zFar, char *engineLogFilename = NULL, char *engineLogInitialText = NULL, bool basicEngineLogging = true);
		//! Constructor/Deconstructor
		~CWindow();

		//! Save screenshot of desktop or application (as bitmap)
		void		Capture_Screenshot(char *filename, bool isDesktop);
		//! Save screen to video (as divx)
		void		Capture_Video();
		//! Close video file
		void		Divx_Cleanup();
		//! Initialize video file
		void		Divx_Initialize(char *filename);
		//! Call before Font_... calls
		void		Font_Begin(int iTexture);
		//! Call after Font_... calls
		void		Font_End();
		//! Print out string - x/y positioning based on percentage of screen - (0,0 == bottom left)
		void		Font_String(float x, float y, float size, float r, float g, float b, bool centerText, const char *fmt, ...);
		//! Loads position of font values (list from [0..127] with 5 integers per line ... ASCII# x1 x2 y1 y2)
		bool		Font_List_Load(char *filename);
		//! Print out string - x/y positioning based on percentage of screen - (0,0 == bottom left)
		void		Font_List_Print(float x, float y, float size, float r, float g, float b, bool alignCenter, bool alignRight, const char *fmt, ...);
		//! Cleanup OpenGL
		void		GL_Cleanup();
		//! Create OpenGL window
		bool		GL_Create_Window(char *title, int width, int height, int bits, bool fullscreen, bool allowResize, bool centerWindow, bool showCursor);
		//! Initialize OpenGL - not needed unless not calling GL_Create_Window(...) - such as when using MFC 
		void		GL_Initialize();
		//! Sets the frustum (perspective)
		void		GL_Perspective(float field_of_view, float aspect);
		//! Get mouse coordinates in respect to the current window
		POINT		Mouse_Coordinates();
		//! Process window messages
		void		Process_Messages();
		//! Get texture data
		GLuint	Texture_Get_Data(int index);
		//! Get texture filename
		char*		Texture_Get_Name(int index);
		//! Load texture (will overwrite specific texture if index is given, mask color default is black) - returns -1 if it fails
		int			Texture_Load(char *filename, int index = -1);
		//! Remove texture
		void		Texture_Remove(int index);
		//! Remove all textures
		void		Texture_Remove_All();
		//! Total textures loaded
		int			Texture_Total();
		//! Reload all textures
		void		Textures_Reload();

		FILE			*pEngineLog;														// Engine information file
		HDC				hDC;																		// Private GDI device context
		HINSTANCE	hInstance;															// Instance of program
		HWND			hWnd;																		// Window handle
		MSG				mMsg;																		// Message structure

		bool			pKeys[256];															// Keyboard array
		float			pFontList[128][4];											// Font list array

		bool			mActive;																// Whether program is active
		bool			mBasicLogging;													// Reduce amount of engine information shown
		bool			mMinimized;															// Whether program is minimized
		bool			mQuit;																	// Quit program flag
		float			mZFar;																	// Z buffer far boundary
		float			mZNear;																	// Z buffer near boudary
		int				mScreenHeight;													// Screen resolution height
		int				mScreenWidth;														// Screen resolution width

	private:
		struct _STexture {
			char					*pFilename;												// Filename of texture
			unsigned int	mTextureID;												// Texture ID
		};

		//! Binds .* file to texture (used by Texture_Load - uses GDI+)
		bool _Build_GDI(char *filename, int index);

		_STexture						*pTextures;										// Texture pointer
		bool								mFullscreen;									// Fullscreen flag
		HGLRC								hRC;													// Permanent rendering context
		PAVIFILE						pDivxFile;										// Video handle
		PAVISTREAM					pDivxStreamNormal;						// Stream of normal video
		PAVISTREAM					pDivxStreamCompressed;				// Stream of compressed video
		float								mDivxTimeLapse;								// To keep at capture at 30 fps
		GdiplusStartupInput	mGdiplusStartupInput;					// GDI+
		int									mTotalTextures;								// Total textures loaded
		long								mDivxFrame;										// Current video frame
		ULONG_PTR						mGdiplusToken;								// GDI+
};

/***************************************************************************/
#endif